%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      RunProject.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% File Version:   1
% Description:    This file runs all project scripts.
%-------------------------------------------------------------------------------
close all;     clear all;     clc;

%%
% Define Analysis Types
kPlot = 1;
kMacBethAnalysis = 1;
kMTFAnalysis = 2;
kCZPAnalysis = 3;
kRealWorldAnalysis = 4;

% Define the range of sensors
minNumSensors = 3;
maxNumSensors = 7;
totalSensors = maxNumSensors - minNumSensors + 1;

% Define Sensor Types
sensorRange = [minNumSensors : maxNumSensors];
sensorRange = [sensorRange, sensorRange, sensorRange];
kSensorText = cell(1, length(sensorRange));
for i = 1:totalSensors,
   kSensorText(i) = {char([num2str(sensorRange(i)) 'Color-Uniform'])};
end
for i = totalSensors+1:2*totalSensors,
   kSensorText(i) = {char([num2str(sensorRange(i)) 'Color-Gaussian-Height-Scaled'])};
end
for i = 2*totalSensors+1:3*totalSensors,
   kSensorText(i) = {char([num2str(sensorRange(i)) 'Color-Gaussian-Height-Width-Scaled'])};
end


%%
% Create arrays to hold the metrics
colorMetrics = [];
frequencyMetrics = [];


for analysisIndex = [kMacBethAnalysis, kMTFAnalysis, kCZPAnalysis, kRealWorldAnalysis],  %[kMacBethAnalysis, kMTFAnalysis, kCZPAnalysis, kRealWorldAnalysis],
      
   % Reset the state of the random number generator
   rand('state',0)

   % Initialize the project settings
   InitializeProject;

   % Define the Scene
   switch analysisIndex
      case {kMacBethAnalysis}
         disp('Analyzing Color Accuracy');
         DefineMacBethScene;
      case {kMTFAnalysis}
         disp('Analyzing MTF');
         DefineMTFScene;
      case {kCZPAnalysis}
         disp('CZP Analysis');
         DefineCZPScene;
      case {kRealWorldAnalysis}
         disp('Real-World Analysis');
         DefineRealWorldScene;
      otherwise
         disp('Unknown scene');
   end

   % Define the Optics
   DefineOptics;

   for sensorIndex = 1:length(sensorRange),
   %for sensorIndex = [15];  % [1, 8, 15]
   
      % Create the Image Sensor
      numSensors = sensorRange(sensorIndex);
      if (sensorIndex <= totalSensors),
         CreateUniformSensor;
      elseif (sensorIndex <= 2*totalSensors),
         CreateAmplitudeSensor;
      else
         CreateAmplitudeWidthSensor;
      end
      
      % Save the resulting image
      if (analysisIndex == kPlot), % Save only once
         saveas(gcf, ['./Images/SensorConfiguration_' char(kSensorText(sensorIndex)) '.eps'], 'epsc2');
         close(gcf)
      end
      
      close all;
      
      % Define the Sensor
      %DefineSensor;  %<---- Fix this to avoid cropping

      % Perform Post-Processing
      ProcessImage;

      % Perform Analysis of Data Collected
      switch analysisIndex
         case {kMacBethAnalysis}
            MacBethAnalysis;
            
            % Save the resulting figure
            saveas(gcf, ['./Images/Macbeth_' char(kSensorText(sensorIndex)) '.eps'], 'epsc2');
            close(gcf)
            
            % Save the results
            colorMetrics = [colorMetrics; deltaE_avg];
      	case {kMTFAnalysis}
            MTFAnalysis;
         
            % Save the resulting figure
            saveas(gcf, ['./Images/MTF_' char(kSensorText(sensorIndex)) '.eps'], 'epsc2');
            close(gcf);
            
            % Save the results
            frequencyMetrics = [frequencyMetrics; results.mtf50];
            
         case {kCZPAnalysis}
            CZPAnalysis;
            
            % Save the resulting figure
            saveas(gcf, ['./Images/CZP_' char(kSensorText(sensorIndex)) '.eps'], 'epsc2');
            close(gcf);
         
         case {kRealWorldAnalysis}
            RealWorldAnalysis;
            
            % Save the resulting figure
            saveas(gcf, ['./Images/RW_' char(kSensorText(sensorIndex)) '.eps'], 'epsc2');
            close(gcf);
            
         otherwise
            disp('Unknown analysis');
      end
   
      
      % Plot the sensor response
      if (analysisIndex == kPlot),
         figure();
         for waveIndex = 1:numSensors,
            cPos(waveIndex)
            [r,g,b] = WavelengthToRGB(nearest(cPos(waveIndex)));
            plot(sensor.spectrum.wave, sensor.color.filterSpectra(:,waveIndex), 'LineWidth', 2, 'Color', [r g b]);
            hold on;
         end
         
         xlim([min(sensor.spectrum.wave) max(sensor.spectrum.wave)]);
         xlabel('Wavelength (nm)');
         ylabel('Transmittance');
         title('Sensor''s Filter Spectra');
         grid on;
         saveas(gcf, ['./Images/SensorFilterSpectra_' char(kSensorText(sensorIndex)) '.eps'], 'epsc2');
         close(gcf);
      end
      
      % Clean up all variables
      %{
      clearvars -except colorMetrics frequencyMetrics ...
                        sensorIndex analysisIndex ...
                        kMacBethAnalysis kMTFAnalysis kCZPAnalysis ...
                        sensorRange kSensorText
      %}

      disp('---------------------------------------------------------------------')
      
      
   end
   
end

% Normalize the data
%colorMetrics = colorMetrics ./ max(colorMetrics);
%frequencyMetrics = frequencyMetrics ./ max(frequencyMetrics);

%%
% Save the data
%save('Results.mat', 'colorMetrics', 'frequencyMetrics', 'kSensorText');


% Plot the final results
%%
load Results.mat

colors = ['r', 'g', 'b', 'm', 'k'];
symbols = ['o', '^', 'p', 'd', 'h'];
n = length(colors);
figure('Position',[0 0 1000 500]);
colorIndex = 1;
symbolIndex = 1;
for i = 1:length(frequencyMetrics),
   plot(frequencyMetrics(i), colorMetrics(i), [colors(colorIndex) symbols(symbolIndex)], 'MarkerFaceColor', colors(colorIndex), 'MarkerSize', 7);
   hold on;
   %text(frequencyMetrics(i),colorMetrics(i),[char(kSensorText(i)), ' \rightarrow'], 'HorizontalAlignment','right')
   colorIndex = colorIndex+1;
   if (colorIndex > length(colors)),
      colorIndex = 1;
      symbolIndex = symbolIndex + 1;
   end
end

% Plot the means from the brute force tests
colorIndex = 1;
for ii = 3:7,
   eval(['load Results_' num2str(ii) '.mat;']);
   eval(['meanVal = mean(Results' num2str(ii) ');']);
   x = meanVal(end-1);
   y = meanVal(end-2);
   plot(x, y, [colors(colorIndex) 's'], 'MarkerFaceColor', colors(colorIndex), 'MarkerSize', 7);
   hold on;
   %text(x,y, ['Mean (' num2str(ii) ') \rightarrow'], 'HorizontalAlignment','right');
   colorIndex = colorIndex + 1;
end

xlabel('MTF-50', 'FontSize', 12);
ylabel('Average  \Delta E', 'FontSize', 12);
title('\bf Color Accuracy vs Frequency Accuracy', 'FontSize', 13);
grid on;
xlim([50 80]);
ylim([0 9]);

kSensorText = {kSensorText{:}, 'Brute Force Mean-3', 'Brute Force Mean-4', ...
               'Brute Force Mean-5', 'Brute Force Mean-6', 'Brute Force Mean-7'};
legend(kSensorText, 'Location', 'EastOutside');
LEGEND BOXOFF;

saveas(gcf, ['./Images/Results.eps'], 'epsc2');
%print(gcf,'./Images/Results.eps','-depsc2','-r300');

% End of File
